# Operasaun bitwise

Operasaun bitwise iha Python permite ita halo operasaun aaritmétika iha nível bit. Iha Python, ita bele uza operadores bitwise hanesan `&` (AND bit-a-bit), `|` (OR bit-a-bit), `^` (XOR bit-a-bit), `~` (NOT bit-a-bit), `<<` (Shift left), no `>>` (Shift right) atu manipula valores iha nível bit.

Lista operadores bitwise sira:

1. `&`: AND bit-a-bit.
2. `|`: OR bit-a-bit.
3. `^`: XOR bit-a-bit.
4. `~`: NOT bit-a-bit.
5. `<<`: Shift left.
6. `>>`: Shift right.

Ezemplu sira:

```python
# AND bit-a-bit
print(5 & 3)  # Sai 1 (101 & 011 = 001)

# OR bit-a-bit
print(5 | 3)  # Sai 7 (101 | 011 = 111)

# XOR bit-a-bit
print(5 ^ 3)  # Sai 6 (101 ^ 011 = 110)

# NOT bit-a-bit
print(~5)     # Sai -6 (~101 = -110)

# Shift left
print(5 << 1) # Sai 10 (101 << 1 = 1010)

# Shift right
print(5 >> 1) # Sai 2 (101 >> 1 = 10)
```

### BITWISE

<img src='https://miro.medium.com/v2/resize:fit:1088/format:webp/1*xIxbMeCIPufBSCAEIKAG9A.png'>

### EZAMPLE

#### AND

<img src='https://journaldev.nyc3.cdn.digitaloceanspaces.com/2019/02/python-bitwise-and-operator.png'>

#### OR

<img src='https://journaldev.nyc3.cdn.digitaloceanspaces.com/2019/02/python-bitwise-or-operator.png'>

#### XOR

<img src='https://journaldev.nyc3.cdn.digitaloceanspaces.com/2019/02/python-bitwise-xor-operator.png'>

#### Bitwise Ones’ Complement Operator

<img src='https://journaldev.nyc3.cdn.digitaloceanspaces.com/2019/02/python-bitwise-ones-complement-operator.png'>

#### Shift Left

<img src='https://journaldev.nyc3.cdn.digitaloceanspaces.com/2019/02/python-bitwise-left-shift-operator.png'>

#### Shift Right

<img src='https://journaldev.nyc3.cdn.digitaloceanspaces.com/2019/02/python-bitwise-right-shift-operator.png'>

Referencia : https://www.digitalocean.com/community/tutorials/python-bitwise-operators


Test
<img src='https://u.pcloud.link/publink/show?code=XZqmh80ZoM9rfadXCAfYd79i2GFviRri8yQ7'>
